/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeError;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;

public class JavaScriptException
extends RhinoException {
    static final long serialVersionUID = -7666130513694669293L;
    private Object value;

    public JavaScriptException(Object value2) {
        this(value2, "", 0);
    }

    public JavaScriptException(Object value2, String sourceName, int lineNumber) {
        this.recordErrorOrigin(sourceName, lineNumber, null, 0);
        this.value = value2;
        if (value2 instanceof NativeError && Context.getContext().hasFeature(10)) {
            NativeError error2 = (NativeError)value2;
            if (!error2.has("fileName", (Scriptable)error2)) {
                error2.put("fileName", (Scriptable)error2, (Object)sourceName);
            }
            if (!error2.has("lineNumber", (Scriptable)error2)) {
                error2.put("lineNumber", (Scriptable)error2, (Object)lineNumber);
            }
            error2.setStackProvider(this);
        }
    }

    public String details() {
        if (this.value == null) {
            return "null";
        }
        if (this.value instanceof NativeError) {
            return this.value.toString();
        }
        try {
            return ScriptRuntime.toString(this.value);
        }
        catch (RuntimeException rte) {
            if (this.value instanceof Scriptable) {
                return ScriptRuntime.defaultObjectToString((Scriptable)this.value);
            }
            return this.value.toString();
        }
    }

    public Object getValue() {
        return this.value;
    }

    public String getSourceName() {
        return this.sourceName();
    }

    public int getLineNumber() {
        return this.lineNumber();
    }
}

